/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.code;


/**
 * Handle authorization code persistence.
 *
 * @since 1.0.0
 */
public interface AuthorizationCodeStore {

  /**
   * Stores a provided authorization code along with the related request for future
   * references.
   * 
   * @param authorizationCodeStoreHolder Related authorization code information
   */
  void store(AuthorizationCodeStoreHolder authorizationCodeStoreHolder);

  /**
   * Returns the authorization code information associated with the provided
   * authorization code.
   * 
   * @param code Authorization code
   * @return The information related to the authorization code or null if not found
   */
  AuthorizationCodeStoreHolder retrieve(String code);

  /**
   * Removes the provided authorization code from the store.
   * 
   * @param authorizationCode Authorization code
   */
  void remove(String authorizationCode);
}
