/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.code;


import org.mule.runtime.api.store.ObjectStore;

import com.mulesoft.modules.oauth2.provider.internal.AbstractObjectStoreBacked;

/**
 * AuthorizationCodeStore implemented with an object store to save all the authorization codes.
 *
 * @since 1.0.0
 */
public class ObjectStoreAuthorizationCode extends
    AbstractObjectStoreBacked<AuthorizationCodeStoreHolder> implements AuthorizationCodeStore {

  public static final String AUTHORIZATION_CODE_PARTITION = "AuthorizationCodes";

  private ObjectStore authorizationCodeObjectStore;

  public void store(final AuthorizationCodeStoreHolder authorizationCodeStoreHolder) {
    putInObjectStore(authorizationCodeStoreHolder.getAuthorizationCode(), authorizationCodeStoreHolder,
                     authorizationCodeObjectStore);
  }

  public AuthorizationCodeStoreHolder retrieve(final String code) {
    return getFromObjectStore(code, authorizationCodeObjectStore);
  }

  public void remove(final String authorizationCode) {
    removeFromObjectStore(authorizationCode, authorizationCodeObjectStore);
  }

  public void setObjectStore(ObjectStore authorizationCodeObjectStore) {
    this.authorizationCodeObjectStore = authorizationCodeObjectStore;
  }
}
