/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.exception;

import static com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError.INVALID_CONFIGURATION;

/**
 * {@inheritDoc}
 *
 * Exception thrown when there is an error in the confguration of the provider
 *
 * @since 1.0.0
 */
public class OAuth2ConfigurationException extends OAuth2Exception {

  private static final long serialVersionUID = 1959981730148405689L;

  public OAuth2ConfigurationException(String errorPhrase) {
    super(errorPhrase, INVALID_CONFIGURATION);
  }
}
