/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.exception;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

import com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError;

/**
 * Base exception thrown when there is an error related to an operation defined in the oauth provider.
 * </p>
 * This exception will be responsible of storing all the information needed to answer via http correctly. That is accomplished
 * by storing the a {@link Message} with {@link org.mule.extension.http.api.HttpListenerResponseAttributes} defined.
 *
 * @since 1.0.0
 */
public class OAuth2Exception extends ModuleException implements ErrorMessageAwareException {

  private static final long serialVersionUID = 530343847587049035L;
  private Message message;

  public OAuth2Exception(String errorPhrase, ErrorTypeDefinition<OAuth2ProviderError> errorTypeDefinition, Throwable cause) {
    super(createStaticMessage(errorPhrase), errorTypeDefinition, cause);
  }

  public OAuth2Exception(String errorPhrase, ErrorTypeDefinition<OAuth2ProviderError> errorTypeDefinition) {
    super(createStaticMessage(errorPhrase), errorTypeDefinition);
  }

  public OAuth2Exception(ErrorTypeDefinition<OAuth2ProviderError> errorTypeDefinition, Throwable cause) {
    super(errorTypeDefinition, cause);
  }

  public OAuth2Exception(String errorPhrase, ErrorTypeDefinition<OAuth2ProviderError> errorErrorTypeDefinition, Message message) {
    this(errorPhrase, errorErrorTypeDefinition);
    this.message = message;
  }

  @Override
  public Message getErrorMessage() {
    return message;
  }
}
