/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.ratelimit;

import org.mule.runtime.extension.api.annotation.Extensible;

import com.mulesoft.modules.oauth2.provider.internal.ratelimit.RateLimitExceededException;

/**
 * A rate limiter will reject operations given a condition met.
 *
 * @since 1.0.0
 */
@Extensible
public interface RateLimiter {

  enum Operation {
    RESOURCE_OWNER_LOGIN
  };
  enum Outcome {
    SUCCESS, FAILURE
  };

  /**
   * @param operation
   * @param context
   * @throws RateLimitExceededException if the operation is rate-limited for the
   *             particular context. The context must be unique within the
   *             operation (for example, a unique ID or username).
   */
  void checkOperationAuthorized(Operation operation, String context) throws RateLimitExceededException;

  void recordOperationOutcome(Operation operation, String context, Outcome outcome);
}
