/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token;


import static org.mule.runtime.api.util.Preconditions.checkArgument;
import org.mule.runtime.api.security.Authentication;

import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;

import java.io.Serializable;

/**
 * Holder to store and retrieve access token information. User authentication might be null for some grant types.
 *
 * @since 1.0.0
 */
public class AccessTokenStoreHolder implements Serializable {

  private static final long serialVersionUID = -1553446120464991582L;
  private final AuthorizationRequest authorizationRequest;
  private final Token accessToken;
  private final ResourceOwnerAuthentication resourceOwnerAuthentication;

  public AccessTokenStoreHolder(final Token accessToken, final AccessTokenStoreHolder previousHolder) {
    this(accessToken, previousHolder.getAuthorizationRequest(),
         previousHolder.resourceOwnerAuthentication);
  }

  public AccessTokenStoreHolder(final Token accessToken,
                                final AuthorizationRequest authorizationRequest,
                                final ResourceOwnerAuthentication resourceOwnerAuthentication) {
    checkArgument(accessToken != null, "accessToken can't be null");

    this.accessToken = accessToken;
    this.authorizationRequest = authorizationRequest;
    this.resourceOwnerAuthentication = resourceOwnerAuthentication;
  }

  public Token getAccessToken() {
    return accessToken;
  }

  public AuthorizationRequest getAuthorizationRequest() {
    return authorizationRequest;
  }

  public ResourceOwnerAuthentication getResourceOwnerAuthentication() {
    return resourceOwnerAuthentication;
  }
}
