/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token;


import static com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError.INVALID_TOKEN;

import org.mule.extension.http.api.HttpListenerResponseAttributes;
import org.mule.runtime.api.message.Message;

import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;


/**
 * {@inheritDoc}
 *
 * Exception thrown when the token is not valid
 *
 * @since 1.0.0.
 */
public class InvalidTokenException extends OAuth2Exception {

  private static final long serialVersionUID = -1109237666394421517L;

  public InvalidTokenException(final String reasonPhrase) {
    super(reasonPhrase, INVALID_TOKEN);
  }

  public InvalidTokenException(Message message) {
    super(((HttpListenerResponseAttributes) message.getAttributes().getValue()).getReasonPhrase(), INVALID_TOKEN, message);
  }

}
