/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

import org.mule.runtime.api.store.ObjectStore;

import com.mulesoft.modules.oauth2.provider.internal.AbstractObjectStoreBacked;

/**
 * Token store backed by an object store that handles access tokens
 *
 * @since 1.0.0
 */
public class ObjectStoreAccessTokenStore extends AbstractObjectStoreBacked<AccessTokenStoreHolder> implements TokenStore {

  public static final String ACCESS_TOKENS_PARTITION = "AccessTokens";

  protected ObjectStore accessTokenObjectStore;

  public void store(final AccessTokenStoreHolder accessTokenStoreHolder) {
    putInObjectStore(accessTokenStoreHolder.getAccessToken().getAccessToken(), accessTokenStoreHolder,
                     accessTokenObjectStore);
  }

  public AccessTokenStoreHolder retrieveByAccessToken(final String accessToken) {
    return getFromObjectStore(accessToken, accessTokenObjectStore);
  }

  public AccessTokenStoreHolder retrieveByRefreshToken(final String refreshToken) {
    return null;
  }

  public AccessTokenStoreHolder remove(final String accessToken) {
    AccessTokenStoreHolder accessTokenStoreHolder = retrieveByAccessToken(accessToken);

    if (accessTokenStoreHolder != null) {
      return removeFromObjectStore(accessToken, accessTokenObjectStore);
    }

    return null;
  }

  public void removeByRefreshToken(final String refreshToken) {
    //Do nothing
  }

  public void setRefreshTokenObjectStore(ObjectStore refreshTokenObjectStore) {
    //Do nothing
  }

  public void setAccessTokenObjectStore(ObjectStore accessTokenObjectStore) {
    this.accessTokenObjectStore = accessTokenObjectStore;
  }
}
