/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

import static com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError.TOKEN_UNAUTHORIZED;
import org.mule.extension.http.api.HttpListenerResponseAttributes;
import org.mule.runtime.api.message.Message;

import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;

/**
 * {@inheritDoc}
 *
 * Exception raised when there is an error validating a token. Weather the token is not valid or there are missing or wrong
 * fields set in the validation.
 *
 * @since 1.0.0
 */
public class UnauthorizedTokenException extends OAuth2Exception {

  private static final long serialVersionUID = -5124594717940363789L;

  public UnauthorizedTokenException(final String reasonPhrase) {
    super(reasonPhrase, TOKEN_UNAUTHORIZED);
  }

  public UnauthorizedTokenException(Message message) {
    super(((HttpListenerResponseAttributes) message.getAttributes().getValue()).getReasonPhrase(), TOKEN_UNAUTHORIZED, message);
  }

}
