/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token.generator;

import org.mule.runtime.extension.api.annotation.Alias;

import com.mulesoft.modules.oauth2.provider.internal.token.generator.ObjectStoreAwareRefreshTokenStrategy;

/**
 * {@inheritDoc}
 *
 * Refresh token strategy where every time a token is refreshed, a new, different refresh token is granted.
 *
 * @since 1.0.0
 */
@Alias("multipleRefreshTokens")
public class MultipleRefreshTokensStrategy extends ObjectStoreAwareRefreshTokenStrategy {

  @Override
  public String generateRefreshToken() {
    return tokenGeneratorStrategy.generateToken();
  }

  @Override
  public String exchangeRefreshToken(String previousToken) {
    return tokenGeneratorStrategy.generateToken();
  }
}
