/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal;

import static org.mule.runtime.api.meta.Category.SELECT;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.annotation.Export;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.dsl.xml.Xml;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.license.RequiresEnterpriseLicense;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;
import com.mulesoft.modules.oauth2.provider.api.ratelimit.PeriodRateLimiter;
import com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter;
import com.mulesoft.modules.oauth2.provider.api.token.generator.RefreshTokenStrategy;
import com.mulesoft.modules.oauth2.provider.api.token.generator.MultipleRefreshTokensStrategy;
import com.mulesoft.modules.oauth2.provider.api.token.generator.NoRefreshTokenStrategy;
import com.mulesoft.modules.oauth2.provider.api.token.generator.SingleRefreshTokenStrategy;
import com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError;


/**
 * Module that provides support for Mule acting as OAuth2 provider.
 *
 * @since 1.0
 */
@Extension(name = "OAuth2 Provider", category = SELECT)
@Xml(prefix = "oauth2-provider")
@Configurations({OAuth2ProviderConfiguration.class})
@ErrorTypes(OAuth2ProviderError.class)
@SubTypeMapping(
    baseType = RefreshTokenStrategy.class,
    subTypes = {
        NoRefreshTokenStrategy.class,
        SingleRefreshTokenStrategy.class,
        MultipleRefreshTokensStrategy.class})
@SubTypeMapping(baseType = RateLimiter.class, subTypes = PeriodRateLimiter.class)
@RequiresEnterpriseLicense(allowEvaluationLicense = true)
@Export(classes = {Constants.class, OAuth2Exception.class},
    resources = {"www-static/auth.html"})
public class OAuth2ProviderModule {


}
