/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.client;


import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientAlreadyExistsException;
import com.mulesoft.modules.oauth2.provider.api.client.NoSuchClientException;

/**
 * Interface to manage client registration.
 */
public interface ClientRegistration {

  /**
   * Add a new client. If the client already exists and the flag {@param failIfPresent} is set to false,
   * it will override it with the new client.
   * 
   * @param client
   * @param failIfPresent
   *
   * @throws ClientAlreadyExistsException if failIfPresent is set to true and a client with the same clientId
   * is in the store
   */
  void addClient(Client client, boolean failIfPresent) throws ClientAlreadyExistsException;


  /**
   * Removes a registered client.
   * 
   * @param clientId The client Id.
   * @throws NoSuchClientException If client does not exist a NoSuchClientException
   *             is thrown.
   */
  void removeClient(final String clientId) throws NoSuchClientException;
}
