/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.generator;

import static com.mulesoft.modules.oauth2.provider.internal.Utils.getResponseStatusCallback;
import static java.util.Arrays.asList;
import static org.mule.runtime.http.api.HttpConstants.Method.GET;
import static org.mule.runtime.http.api.HttpConstants.Method.POST;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.AuthorizationRequestProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderRequestProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.ServeLoginPageProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.ValidateAuthorizationRequestProcessor;
import org.mule.runtime.http.api.server.RequestHandlerManager;

import java.util.Set;

public class AuthorizationHandlerGenerator extends BaseRequestHandlerGenerator {

  @Override
  public void generate(OAuthConfiguration configuration) {
    HttpServer httpServer = configuration.getHttpServer();
    OAuth2ProviderRequestProcessor oAuth2ProviderRequestProcessor = new OAuth2ProviderRequestProcessor(configuration);
    ValidateAuthorizationRequestProcessor validateAuthorizationRequestProcessor =
        new ValidateAuthorizationRequestProcessor(configuration);
    ServeLoginPageProcessor serveLoginPageProcessor = new ServeLoginPageProcessor(configuration);
    AuthorizationRequestProcessor authorizationRequestProcessor = new AuthorizationRequestProcessor(configuration);

    requestHandlerManager = httpServer.addRequestHandler(
                                                         asList(GET.toString(), POST.toString()),
                                                         configuration.getAuthorizationConfig().getPath(),
                                                         (requestContext, responseCallback) -> {
                                                           HttpResponseBuilder httpResponseBuilder = HttpResponse.builder();
                                                           OAuth2ProviderProcessor oAuth2ProviderProcessor;
                                                           if (requestContext.getRequest().getMethod()
                                                               .equalsIgnoreCase(GET.toString())) {
                                                             oAuth2ProviderProcessor = (httpRequestContext, responseBuilder) -> {
                                                               Pair<Set<String>, Client> responsePair =
                                                                   validateAuthorizationRequestProcessor
                                                                       .process(httpRequestContext);
                                                               serveLoginPageProcessor.process(httpRequestContext,
                                                                                               responsePair.getSecond(),
                                                                                               responsePair.getFirst(),
                                                                                               responseBuilder);
                                                             };
                                                           } else {
                                                             oAuth2ProviderProcessor =
                                                                 authorizationRequestProcessor::processRequest;
                                                           }
                                                           oAuth2ProviderRequestProcessor.process(requestContext,
                                                                                                  httpResponseBuilder,
                                                                                                  oAuth2ProviderProcessor);
                                                           responseCallback.responseReady(httpResponseBuilder.build(),
                                                                                          getResponseStatusCallback());
                                                         });
  }

}
