/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2ConfigurationException;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;

import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public abstract class AbstractServePageProcessor extends OAuth2ProviderRequestProcessor {

  private final Template template;
  private final String loginPage;

  public AbstractServePageProcessor(final OAuthConfiguration configuration, final String page) {
    super(configuration);

    final Properties properties = new Properties();
    properties.setProperty("resource.loader", "file,class");
    properties.setProperty("file.resource.loader.class",
                           "com.mulesoft.modules.oauth2.provider.internal.velocity.FileResourceLoader");
    properties.setProperty("class.resource.loader.class",
                           "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
    properties.setProperty("introspector.conversion_handler.class", "none");
    properties.setProperty("parser.space_gobbling", "bc");
    properties.setProperty("directive.if.empty_check", "false");
    properties.setProperty("parser.allow_hyphen_in_identifiers", "true");
    properties.setProperty("velocimacro.enable_bc_mode", "true");
    properties.setProperty("event_handler.invalid_references.quiet", "true");
    properties.setProperty("event_handler.invalid_references.null", "true");
    properties.setProperty("event_handler.invalid_references.tested", "true");
    properties.setProperty("velocimacro.arguments.preserve_literals", "true");
    properties.setProperty("runtime.conversion.handler.class", "none");
    properties.setProperty("space.gobbling", "bc");

    final VelocityEngine velocity = new VelocityEngine(properties);

    loginPage = configuration.getAuthorizationConfig().getLoginPage();

    if (velocity.resourceExists(loginPage)) {
      template = velocity.getTemplate(page);
    } else {
      //Set null to properly fail in the render stage
      template = null;
    }

  }

  protected String render(final Map<String, Object> context) {
    if (template == null) {
      throw new OAuth2ConfigurationException("Authorization page not found, check your configuration: " + loginPage);
    }
    final VelocityContext velocityContext = new VelocityContext(context);
    final StringWriter mergedContent = new StringWriter();
    template.merge(velocityContext, mergedContent);
    return mergedContent.toString();
  }
}
