/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import static com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException.ErrorType.INVALID_REQUEST;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;

public class ClientSecretCredentials implements Credentials {

  private Credentials delegate;

  public ClientSecretCredentials(final String clientId, final char[] clientSecret) {
    this.delegate = new DefaultMuleCredentials(clientId, clientSecret);
  }

  @Override
  public String getUsername() {
    return delegate.getUsername();
  }

  @Override
  public char[] getPassword() {
    return delegate.getPassword();
  }

  public String getClientId() {
    return getUsername();
  }

  public String getClientSecret() {
    return new String(getPassword());
  }

  @Override
  public Object getRoles() {
    throw new UnsupportedOperationException(new RequestProcessingException(INVALID_REQUEST,
                                                                           "Wrong credentials type"));
  }
}
