/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import static com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException.ErrorType.INVALID_CLIENT;
import static com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException.ErrorType.INVALID_CLIENT_ID;
import static com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException.ErrorType.INVALID_REQUEST;
import static com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException.ErrorType.UNAUTHORIZED_CLIENT;
import static java.lang.Boolean.parseBoolean;
import static java.lang.System.getProperty;
import static org.mule.runtime.core.api.config.MuleProperties.SYSTEM_PROPERTY_PREFIX;

/**
 * This class was created to maintain backwards compatibility when creating a {@link RequestProcessingException}.
 */
public class RequestProcessingExceptionFactory {

  public static final String OLD_EXCEPTIONS_BEHAVIOR_SYSTEM_PROPERTY = SYSTEM_PROPERTY_PREFIX + ".oauth.provider.oldErrors";

  private static boolean oldExceptions;

  static {
    oldExceptions = parseBoolean(getProperty(OLD_EXCEPTIONS_BEHAVIOR_SYSTEM_PROPERTY, "false"));
  }

  public static RequestProcessingException noClientAuthenticationException() {
    RequestProcessingException.ErrorType errorType = INVALID_CLIENT;
    if (oldExceptions) {
      errorType = INVALID_REQUEST;
    }
    return new RequestProcessingException(errorType,
                                          "No client identification nor authentication found");
  }

  public static RequestProcessingException noClientIdException() {
    RequestProcessingException.ErrorType errorType = INVALID_REQUEST;
    if (oldExceptions) {
      errorType = INVALID_CLIENT_ID;
    }
    return new RequestProcessingException(errorType,
                                          "Missing clientId");
  }

  public static RequestProcessingException wrongClientSecretException() {
    return new RequestProcessingException(INVALID_CLIENT,
                                          "Invalid credentials");
  }

  public static RequestProcessingException unkownClientIdException() {
    RequestProcessingException.ErrorType errorType = INVALID_CLIENT;
    if (oldExceptions) {
      errorType = UNAUTHORIZED_CLIENT;
    }
    return new RequestProcessingException(errorType,
                                          "Invalid credentials");
  }
}
