/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.token;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import org.mule.runtime.api.security.ServerSecurityException;

/**
 * See: http://tools.ietf.org/html/draft-ietf-oauth-v2-28#section-5.2<br/>
 * The provided authorization grant (e.g. authorization code, resource owner credentials) or refresh token is invalid, expired,
 * revoked, does not match the redirection URI used in the authorization request, or was issued to another client.
 */
public class InvalidGrantException extends ServerSecurityException {

  private static final long serialVersionUID = 1756660735387308711L;

  public InvalidGrantException(final String msg) {
    super(createStaticMessage(msg));
  }

  public InvalidGrantException(final String msg, Throwable t) {
    super(createStaticMessage(msg), t);
  }
}
