/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.velocity;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class FileResourceLoader extends ResourceLoader {

  @Override
  public void init(final ExtProperties configuration) {
    // NOOP
  }

  @Override
  public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
    Reader reader = null;
    InputStream inputStream = null;
    try {
      inputStream = new FileInputStream(source);
      return this.buildReader(inputStream, encoding);
    } catch (final IOException io) {
      close(inputStream);
      throw new ResourceNotFoundException(io);
    }
  }

  private void close(InputStream inputStream) {
    if (inputStream != null) {
      try {
        inputStream.close();
      } catch (IOException e) {
      }
    }
  }

  @Override
  public boolean resourceExists(final String resourceName) {
    return new File(resourceName).isFile();
  }

  @Override
  public boolean isSourceModified(final Resource resource) {
    return resource.getLastModified() != getLastModified(resource);
  }

  @Override
  public long getLastModified(final Resource resource) {
    final File file = new File(resource.getName());
    if (file.isFile() && file.canRead()) {
      return file.lastModified();
    } else {
      return 0;
    }
  }
}
