/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal;

import java.io.Serializable;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public abstract class AbstractObjectStoreBacked<T extends Serializable> {
    protected T getFromObjectStore(String key, ObjectStore<T> objectStore) {
        this.validateObjectStore(objectStore);
        if (key == null) {
            return null;
        }
        try {
            return (T)objectStore.retrieve(key);
        }
        catch (ObjectDoesNotExistException odnee) {
            return null;
        }
        catch (ObjectStoreException ose) {
            throw new MuleRuntimeException((Throwable)ose);
        }
    }

    protected void putInObjectStore(String key, T value, ObjectStore<T> objectStore) {
        try {
            this.putInObjectStore(key, value, objectStore, false);
        }
        catch (ObjectAlreadyExistsException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected void putInObjectStore(String key, T value, ObjectStore<T> objectStore, boolean failIfPresent) throws ObjectAlreadyExistsException {
        this.internalPutInObjectStore(key, value, objectStore, 3, failIfPresent);
    }

    private void internalPutInObjectStore(String key, T value, ObjectStore<T> objectStore, int attemptsLeft, boolean failIfPresent) throws ObjectAlreadyExistsException {
        this.validateObjectStore(objectStore);
        try {
            if (!failIfPresent && objectStore.contains(key)) {
                this.removeFromObjectStore(key, objectStore);
            }
            objectStore.store(key, value);
        }
        catch (ObjectAlreadyExistsException oaee) {
            if (attemptsLeft <= 0 || failIfPresent) {
                throw oaee;
            }
            this.internalPutInObjectStore(key, value, objectStore, attemptsLeft - 1, failIfPresent);
        }
        catch (ObjectStoreException ose) {
            throw new MuleRuntimeException((Throwable)ose);
        }
    }

    protected T removeFromObjectStore(String key, ObjectStore<T> objectStore) {
        this.validateObjectStore(objectStore);
        try {
            return (T)objectStore.remove(key);
        }
        catch (ObjectDoesNotExistException odnee) {
            return null;
        }
        catch (ObjectStoreException ose) {
            throw new MuleRuntimeException((Throwable)ose);
        }
    }

    private void validateObjectStore(ObjectStore objectStore) {
        if (objectStore == null) {
            throw new IllegalArgumentException("No object store has been initialized.");
        }
    }
}

