/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.google.gson.Gson;
import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;
import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientType;
import com.mulesoft.modules.oauth2.provider.api.client.NoSuchClientException;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationCodeStoreHolder;
import com.mulesoft.modules.oauth2.provider.api.token.Token;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderRequestProcessor;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestData;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException;
import com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingExceptionFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;

public class TokenRequestProcessor
extends OAuth2ProviderRequestProcessor {
    private static final ResourceOwnerAuthentication NO_RESOURCE_OWNER_AUTHENTICATION = null;

    public TokenRequestProcessor(OAuthConfiguration configuration) {
        super(configuration);
    }

    public void processRequest(RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws SecurityException {
        Constants.RequestGrantType grantType = this.getSupportedRequestGrantTypeOrFail(requestData);
        Client client = this.getKnownClientOrFail(requestData);
        if (client.getType() == ClientType.CONFIDENTIAL && !this.validateClientCredentials(client, requestData)) {
            throw RequestProcessingExceptionFactory.wrongClientSecretException();
        }
        if (!client.isGrantTypeAuthorized(grantType)) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.UNSUPPORTED_GRANT_TYPE, "Client does not support grant type: " + (Object)((Object)grantType));
        }
        if (grantType == Constants.RequestGrantType.AUTHORIZATION_CODE) {
            this.processAuthorizationCodeRequest(grantType, client, requestData, httpResponseBuilder);
        } else if (grantType == Constants.RequestGrantType.REFRESH_TOKEN) {
            this.processRefreshTokenRequest(grantType, client, requestData, httpResponseBuilder);
        } else if (grantType == Constants.RequestGrantType.PASSWORD) {
            this.processPasswordRequest(grantType, client, requestData, httpResponseBuilder);
        } else if (grantType == Constants.RequestGrantType.CLIENT_CREDENTIALS) {
            this.processClientCredentialsRequest(grantType, client, requestData, httpResponseBuilder);
        } else {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.UNSUPPORTED_GRANT_TYPE, "Unsupported grant type: " + (Object)((Object)grantType));
        }
    }

    @Override
    protected RequestProcessingException convertToRequestProcessingException(Exception e) {
        if (e instanceof NoSuchClientException) {
            return RequestProcessingExceptionFactory.unkownClientIdException();
        }
        return super.convertToRequestProcessingException(e);
    }

    private void processAuthorizationCodeRequest(Constants.RequestGrantType grantType, Client client, RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws SecurityException {
        String authorizationCode = this.getMandatoryParameterOrFail(requestData, "code");
        String redirectUri = this.getMandatoryParameterOrFail(requestData, "redirect_uri");
        AuthorizationCodeStoreHolder authorizationCodeStoreHolder = this.configuration.getAuthorizationCodeManager().consumeAuthorizationCode(authorizationCode);
        AuthorizationRequest pendingAuthorizationRequest = authorizationCodeStoreHolder.getAuthorizationRequest();
        if (!pendingAuthorizationRequest.getClientId().equals(client.getClientId())) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_CLIENT_ID);
        }
        if (!StringUtils.equals((CharSequence)StringUtils.trimToNull((String)redirectUri), (CharSequence)StringUtils.trimToNull((String)pendingAuthorizationRequest.getRedirectUri()))) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_REDIRECTION_URI);
        }
        Token accessToken = this.configuration.getTokenManager().grantAccessToken(grantType, pendingAuthorizationRequest, NO_RESOURCE_OWNER_AUTHENTICATION);
        this.respondToken(accessToken, httpResponseBuilder);
    }

    private void processRefreshTokenRequest(Constants.RequestGrantType grantType, Client client, RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws SecurityException {
        String refreshToken = this.getMandatoryParameterOrFail(requestData, "refresh_token");
        Set<String> effectiveScopes = this.getEffectiveScopes(requestData, client);
        Token accessToken = this.configuration.getTokenManager().exchangeRefreshToken(refreshToken, client.getClientId());
        if (CollectionUtils.isNotEmpty(effectiveScopes) && !CollectionUtils.isSubCollection(effectiveScopes, accessToken.getScopes())) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.INVALID_SCOPE, "Scope doesn't match originally granted scope");
        }
        this.respondToken(accessToken, httpResponseBuilder);
    }

    private void processPasswordRequest(Constants.RequestGrantType grantType, Client client, RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws SecurityException {
        Pair<Boolean, ResourceOwnerAuthentication> resourceOwnerAuthenticationResult = this.validateResourceOwnerCredentials(client, requestData);
        if (!((Boolean)resourceOwnerAuthenticationResult.getLeft()).booleanValue()) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.ACCESS_DENIED);
        }
        Set<String> effectiveScopes = this.getEffectiveScopes(requestData, client);
        Token accessToken = this.configuration.getTokenManager().grantAccessToken(Constants.RequestGrantType.TOKEN, client.getClientId(), effectiveScopes, (ResourceOwnerAuthentication)resourceOwnerAuthenticationResult.getRight());
        this.respondToken(accessToken, httpResponseBuilder);
    }

    private void processClientCredentialsRequest(Constants.RequestGrantType grantType, Client client, RequestData requestData, HttpResponseBuilder httpResponseBuilder) throws SecurityException {
        if (client.getType() != ClientType.CONFIDENTIAL) {
            throw new RequestProcessingException(RequestProcessingException.ErrorType.UNAUTHORIZED_CLIENT, "Client is not confidential!");
        }
        if (!this.validateClientCredentials(client, requestData)) {
            throw RequestProcessingExceptionFactory.wrongClientSecretException();
        }
        Set<String> effectiveScopes = this.getEffectiveScopes(requestData, client);
        Token accessToken = this.configuration.getTokenManager().grantAccessToken(Constants.RequestGrantType.TOKEN, client.getClientId(), effectiveScopes, NO_RESOURCE_OWNER_AUTHENTICATION);
        this.respondToken(accessToken, httpResponseBuilder);
    }

    private void respondToken(Token accessToken, HttpResponseBuilder httpResponseBuilder) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("access_token", accessToken.getAccessToken());
        response.put("token_type", accessToken.getType());
        response.put("expires_in", this.configuration.getTokenConfig().getTokenTtlInSeconds());
        if (CollectionUtils.isNotEmpty(accessToken.getScopes())) {
            response.put("scope", Utils.stringifyScopes(accessToken.getScopes()));
        }
        if (StringUtils.isNotBlank((CharSequence)accessToken.getRefreshToken())) {
            response.put("refresh_token", accessToken.getRefreshToken());
        }
        httpResponseBuilder.addHeader("Content-Type", MediaType.APPLICATION_JSON.toRfcString());
        httpResponseBuilder.entity((HttpEntity)new ByteArrayHttpEntity(new Gson().toJson(response).getBytes()));
    }

    @Override
    protected void handleException(RequestProcessingException exception, RequestData requestData, HttpResponseBuilder httpResponseBuilder) {
        super.handleException(exception, requestData, httpResponseBuilder);
        if (StringUtils.isNotBlank((CharSequence)this.getOptionalParameter(requestData, "Authorization")) && exception.getErrorType() == RequestProcessingException.ErrorType.INVALID_CLIENT) {
            httpResponseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
            httpResponseBuilder.addHeader("WWW-Authenticate", "Basic realm=\"OAuth2 Client Realm\"");
        }
    }

    @Override
    protected boolean isRedirectingForError(RequestProcessingException.ErrorType errorType, String redirectUri) {
        return false;
    }

    @Override
    protected void setResponsePayload(HttpResponseBuilder responseBuilder, String encoding, String ... parameters) {
        responseBuilder.addHeader("Content-Type", MediaType.APPLICATION_JSON.toRfcString());
        responseBuilder.entity((HttpEntity)new ByteArrayHttpEntity(new Gson().toJson(this.keyValuePairsToMap(parameters)).getBytes()));
    }

    @Override
    protected Map<String, Object> keyValuePairsToMap(Object ... parameters) {
        Preconditions.checkArgument((parameters.length % 2 == 0 ? 1 : 0) != 0, (String)"need an even number of (param name, param value) string pairs");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < parameters.length; i += 2) {
            Object value = parameters[i + 1];
            if (value == null) continue;
            String key = (String)parameters[i];
            result.put(key, StringEscapeUtils.escapeHtml((String)((String)value)));
        }
        return result;
    }
}

