/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;
import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;
import com.mulesoft.modules.oauth2.provider.api.token.Token;
import java.io.Serializable;
import org.mule.runtime.api.util.Preconditions;

public class AccessTokenStoreHolder
implements Serializable {
    private static final long serialVersionUID = -1553446120464991582L;
    private final AuthorizationRequest authorizationRequest;
    private final Token accessToken;
    private final ResourceOwnerAuthentication resourceOwnerAuthentication;

    public AccessTokenStoreHolder(Token accessToken, AccessTokenStoreHolder previousHolder) {
        this(accessToken, previousHolder.getAuthorizationRequest(), previousHolder.resourceOwnerAuthentication);
    }

    public AccessTokenStoreHolder(Token accessToken, AuthorizationRequest authorizationRequest, ResourceOwnerAuthentication resourceOwnerAuthentication) {
        Preconditions.checkArgument((accessToken != null ? 1 : 0) != 0, (String)"accessToken can't be null");
        this.accessToken = accessToken;
        this.authorizationRequest = authorizationRequest;
        this.resourceOwnerAuthentication = resourceOwnerAuthentication;
    }

    public Token getAccessToken() {
        return this.accessToken;
    }

    public AuthorizationRequest getAuthorizationRequest() {
        return this.authorizationRequest;
    }

    public ResourceOwnerAuthentication getResourceOwnerAuthentication() {
        return this.resourceOwnerAuthentication;
    }
}

