/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.client;

import static com.mulesoft.modules.oauth2.provider.internal.error.OAuth2ProviderError.NO_SUCH_CLIENT;

import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2Exception;

/**
 * {@inheritDoc}
 *
 * Exception thrown when trying to get a client with a clientId that was never registered
 *
 * @since 1.0.0
 */
public class NoSuchClientException extends OAuth2Exception {

  private static final long serialVersionUID = -3204802829729123029L;

  public NoSuchClientException(final String msg) {
    super(msg, NO_SUCH_CLIENT);
  }

}
