/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.client;


import static java.lang.String.format;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;

import com.mulesoft.modules.oauth2.provider.internal.AbstractObjectStoreBacked;
import com.mulesoft.modules.oauth2.provider.internal.client.ClientRegistration;

/**
 * Client store backed with an object store for saving all the clients
 *
 * @since 1.0.0
 */
public class ObjectStoreClientStore extends AbstractObjectStoreBacked<Client>
    implements ClientStore, ClientRegistration {

  public static final String CLIENTS_PARTITION = "Clients";

  private ObjectStore clientObjectStore;

  public Client getClientById(final String clientId) throws NoSuchClientException {
    final Client client = getFromObjectStore(clientId, clientObjectStore);
    if (client == null) {
      throw new NoSuchClientException("Client Id is invalid");
    }
    return client;
  }

  public void addClient(final Client client, boolean failIfPresent) throws ClientAlreadyExistsException {
    try {
      putInObjectStore(client.getClientId(), client, clientObjectStore, failIfPresent);
    } catch (ObjectAlreadyExistsException e) {
      throw new ClientAlreadyExistsException(format("The client with ID: %s is already registered", client.getClientId()));
    }
  }

  public void removeClient(final String clientId) throws NoSuchClientException {
    final Client client = removeFromObjectStore(clientId, clientObjectStore);
    if (client == null) {
      throw new NoSuchClientException(format("Client with ID %s does not exist", clientId));
    }
  }

  public void setObjectStore(ObjectStore clientObjectStore) {
    this.clientObjectStore = clientObjectStore;
  }

  public ObjectStore getClientObjectStore() {
    return clientObjectStore;
  }
}
