/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.code;

import com.mulesoft.modules.oauth2.provider.api.AuthorizationRequest;

import java.io.Serializable;

/**
 * Holder for conveniently storing authorization code and related request information
 *
 * @since 1.0.0
 */
public class AuthorizationCodeStoreHolder implements Serializable {


  private static final long serialVersionUID = -8539795850623878534L;
  private final String authorizationCode;
  private final AuthorizationRequest authorizationRequest;

  public AuthorizationCodeStoreHolder(final String authorizationCode,
                                      final AuthorizationRequest authorizationRequest) {
    this.authorizationCode = authorizationCode;
    this.authorizationRequest = authorizationRequest;
  }

  public String getAuthorizationCode() {
    return authorizationCode;
  }

  public AuthorizationRequest getAuthorizationRequest() {
    return authorizationRequest;
  }
}
