/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.code;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;

/**
 * POJO to store information about authorization's handling configuration
 *
 * @since 1.0.0
 */
public class AuthorizationConfig {

  @Parameter
  @Expression(NOT_SUPPORTED)
  @Optional(defaultValue = "www-static/auth.html")
  private String loginPage;

  @Parameter
  @Expression(NOT_SUPPORTED)
  @Optional(defaultValue = "/authorize")
  private String path;

  @Parameter
  @Expression(NOT_SUPPORTED)
  @Optional
  @ObjectStoreReference
  private ObjectStore authorizationCodeStore;


  public String getLoginPage() {
    return loginPage;
  }

  public String getPath() {
    return path;
  }

  public ObjectStore getAuthorizationCodeStore() {
    return authorizationCodeStore;
  }

}
