/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

import org.mule.runtime.api.store.ObjectStore;

/**
 * Token store backed by an object store that handles both access and refresh tokens
 *
 * @since 1.0.0
 */
public class ObjectStoreAccessAndRefreshTokenStore extends ObjectStoreAccessTokenStore implements TokenStore {

  public static final String REFRESH_TOKENS_PARTITION = "RefreshTokens";

  private ObjectStore refreshTokenObjectStore;

  public void store(final AccessTokenStoreHolder accessTokenStoreHolder) {
    super.store(accessTokenStoreHolder);
    final String refreshToken = accessTokenStoreHolder.getAccessToken().getRefreshToken();
    if (isNotBlank(refreshToken)) {
      putInObjectStore(refreshToken, accessTokenStoreHolder, refreshTokenObjectStore);
    }
  }

  public AccessTokenStoreHolder retrieveByRefreshToken(final String refreshToken) {
    return getFromObjectStore(refreshToken, refreshTokenObjectStore);
  }

  public AccessTokenStoreHolder remove(final String accessToken) {
    AccessTokenStoreHolder accessTokenStoreHolder = super.remove(accessToken);
    if (accessTokenStoreHolder != null) {
      final String refreshToken = accessTokenStoreHolder.getAccessToken().getRefreshToken();
      if (isNotBlank(refreshToken)) {
        return removeFromObjectStore(refreshToken, refreshTokenObjectStore);
      }
    }
    return null;
  }

  public void removeByRefreshToken(final String refreshToken) {
    AccessTokenStoreHolder accessTokenStoreHolder = retrieveByRefreshToken(refreshToken);
    if (accessTokenStoreHolder != null) {
      removeFromObjectStore(refreshToken, refreshTokenObjectStore);
      final String accessToken = accessTokenStoreHolder.getAccessToken().getAccessToken();
      if (isNotBlank(accessToken)) {
        removeFromObjectStore(accessToken, accessTokenObjectStore);
      }
    }
  }

  public void setRefreshTokenObjectStore(ObjectStore refreshTokenObjectStore) {
    this.refreshTokenObjectStore = refreshTokenObjectStore;
  }
}
