/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;

import com.mulesoft.modules.oauth2.provider.api.token.generator.NoRefreshTokenStrategy;
import com.mulesoft.modules.oauth2.provider.api.token.generator.RefreshTokenStrategy;

import java.util.concurrent.TimeUnit;

/**
 * POJO that stores configuration information for how to handle tokens
 *
 * @since 1.0.0
 */
public class TokenConfig {

  /**
   * Endpoint to call when wanting to request a new token
   */
  @Parameter
  @Optional(defaultValue = "/token")
  @Expression(NOT_SUPPORTED)
  private String path;

  /**
   * ObjectStore configuration information for storing token related data
   */
  @Parameter
  @Optional
  @Expression(NOT_SUPPORTED)
  @ObjectStoreReference
  private ObjectStore tokenStore;

  /**
   * The refresh token strategy to use. By default no refresh token should be generated
   */
  @Parameter
  @Optional
  @Expression(NOT_SUPPORTED)
  @NullSafe(defaultImplementingType = NoRefreshTokenStrategy.class)
  private RefreshTokenStrategy refreshTokenStrategy;

  /**
   * The time in seconds before an access token code expires.
   */
  @Parameter
  @Expression(NOT_SUPPORTED)
  @Optional(defaultValue = "86400")
  private int tokenTtl;

  /**
   * The time unit for the token ttl.
   */
  @Parameter
  @Expression(NOT_SUPPORTED)
  @Optional(defaultValue = "SECONDS")
  private TimeUnit tokenTtlTimeUnit;

  public String getPath() {
    return path;
  }

  public ObjectStore getTokenStore() {
    return tokenStore;
  }

  public RefreshTokenStrategy getRefreshTokenStrategy() {
    return refreshTokenStrategy;
  }

  public int getTokenTtl() {
    return tokenTtl;
  }

  public TimeUnit getTokenTtlTimeUnit() {
    return tokenTtlTimeUnit;
  }

  public Long getTokenTtlInSeconds() {
    return tokenTtlTimeUnit.toSeconds(tokenTtl);
  }
}
