/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token;

/**
 * Handle access token persistence.
 *
 * @since 1.0.0
 */
public interface TokenStore {

  void store(AccessTokenStoreHolder accessTokenStoreHolder);

  AccessTokenStoreHolder retrieveByAccessToken(String accessToken);

  AccessTokenStoreHolder retrieveByRefreshToken(String refreshToken);

  /**
   * Removes the access token and its related refresh token if it exists.
   * @param accessToken the access token to delete.
   * @return the {@link AccessTokenStoreHolder} that was deleted
   *         or null if the token doesn't exist in the store.
   */
  AccessTokenStoreHolder remove(String accessToken);

  void removeByRefreshToken(String refreshToken);
}
