/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token.generator;


import org.mule.runtime.extension.api.annotation.Alias;

import com.mulesoft.modules.oauth2.provider.internal.token.generator.AbstractRefreshTokenStrategy;

/**
 * {@inheritDoc}
 *
 * Refresh token strategy used when no refresh tokens will be granted with an access token.
 *
 * @since 1.0.0
 */
@Alias("noRefreshToken")
public class NoRefreshTokenStrategy extends AbstractRefreshTokenStrategy {

  @Override
  public String generateRefreshToken() {
    return null;
  }

  @Override
  public String exchangeRefreshToken(String previousToken) {
    return null;
  }
}
