/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.api.token.generator;

import org.mule.runtime.extension.api.annotation.Extensible;

/**
 * Interface to implement according to the refresh token strategy wanted.
 *
 * @since 1.0
 */
@Extensible
public interface RefreshTokenStrategy {

  /**
   * Get a refresh token according to the defined strategy.
   *
   * @return a refresh token
   */
  String exchangeRefreshToken(String previousToken);

  /**
   * Generate a new refresh token according to the strategy defined
   *
   * @return a new refresh token
   */
  String generateRefreshToken();

}
