/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;
import org.mule.runtime.api.security.ServerSecurityException;

public class OAuth2ProviderSecurityException extends ServerSecurityException {

  private static final long serialVersionUID = 6992131004533591878L;

  public OAuth2ProviderSecurityException(String errorPhrase) {
    super(createStaticMessage(errorPhrase));
  }

  public OAuth2ProviderSecurityException(String errorPhrase, Throwable cause) {
    super(createStaticMessage(errorPhrase), cause);
  }

}
