/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.client;


import static com.mulesoft.modules.oauth2.provider.api.Constants.RequestGrantType.AUTHORIZATION_CODE;
import static java.lang.String.format;
import static org.mule.runtime.api.util.Preconditions.checkArgument;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientAlreadyExistsException;
import com.mulesoft.modules.oauth2.provider.api.client.ClientStore;

public class ClientManager {

  private ClientStore clientStore;

  public ClientManager(ClientStore clientStore) {
    this.clientStore = clientStore;
  }

  public void addClient(Client client, boolean failIfPresent) throws ClientAlreadyExistsException {
    checkClientConfiguration(client);
    clientStore.addClient(client, failIfPresent);
  }

  public void removeClient(String clientId) {
    clientStore.removeClient(clientId);
  }

  public Client getClientById(String id) {
    return clientStore.getClientById(id);
  }

  private void checkClientConfiguration(Client client) {
    checkArgument(!(client.getAuthorizedGrantTypes().contains(AUTHORIZATION_CODE) && client.getRedirectUris().isEmpty()),
                  format("Client '%s' is authorized for %s grant type but does not have any redirect Uri", client.getClientName(),
                         AUTHORIZATION_CODE));
  }

}
