/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.error;

import static org.mule.runtime.extension.api.error.MuleErrors.SERVER_SECURITY;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.Optional;

public enum OAuth2ProviderError implements ErrorTypeDefinition<OAuth2ProviderError> {

  OAUTH_SERVER_SECURITY(SERVER_SECURITY), INVALID_CONFIGURATION(OAUTH_SERVER_SECURITY), INVALID_CLIENT(
      OAUTH_SERVER_SECURITY), CLIENT_ALREADY_EXISTS(OAUTH_SERVER_SECURITY), NO_SUCH_CLIENT(
          OAUTH_SERVER_SECURITY), TOKEN_UNAUTHORIZED(OAUTH_SERVER_SECURITY), INVALID_TOKEN(OAUTH_SERVER_SECURITY);

  private ErrorTypeDefinition<? extends Enum<?>> parent;

  OAuth2ProviderError(ErrorTypeDefinition<? extends Enum<?>> parent) {
    this.parent = parent;
  }

  OAuth2ProviderError() {}

  @Override
  public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
    return Optional.ofNullable(parent);
  }

}
