/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.generator;

import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;

import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRequestHandlerGenerator implements RequestHandlerGenerator {

  private static final Logger logger = LoggerFactory.getLogger(BaseRequestHandlerGenerator.class);
  protected OAuthConfiguration configuration;
  protected RequestHandlerManager requestHandlerManager;

  @Override
  public void dispose() {
    requestHandlerManager.stop();
    requestHandlerManager.dispose();
  }
}
