/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.generator;

import static com.mulesoft.modules.oauth2.provider.internal.Utils.getResponseStatusCallback;
import static java.util.Arrays.asList;
import static org.mule.runtime.http.api.HttpConstants.Method.POST;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServer;

import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.TokenRequestProcessor;

public class CreateAccessTokenHandlerGenerator extends BaseRequestHandlerGenerator {

  @Override
  public void generate(OAuthConfiguration configuration) {
    HttpServer httpServer = configuration.getHttpServer();
    TokenRequestProcessor tokenProviderRequestProcessor = new TokenRequestProcessor(configuration);
    requestHandlerManager = httpServer.addRequestHandler(
                                                         asList(POST.toString()),
                                                         configuration.getTokenConfig().getPath(),
                                                         (requestContext, responseCallback) -> {
                                                           HttpResponseBuilder responseBuilder = HttpResponse.builder();
                                                           tokenProviderRequestProcessor.process(requestContext, responseBuilder,
                                                                                                 tokenProviderRequestProcessor::processRequest);
                                                           responseCallback.responseReady(responseBuilder.build(),
                                                                                          getResponseStatusCallback());
                                                         });
  }

}
