/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import static com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingException.ErrorType.SERVER_ERROR;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;

import java.io.IOException;

public class RequestData {

  private HttpRequestContext context;
  private String content;

  public RequestData(HttpRequestContext httpRequestContext) throws RequestProcessingException {
    this.context = httpRequestContext;
    try {
      content = new String(httpRequestContext.getRequest().getEntity().getBytes());
    } catch (IOException e) {
      throw new RequestProcessingException(SERVER_ERROR, e);
    }
  }

  public HttpRequestContext getContext() {
    return this.context;
  }

  public String getContent() {
    return content;
  }
}
