/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import static com.mulesoft.modules.oauth2.provider.api.Constants.CLIENT_ID_PARAMETER;
import static com.mulesoft.modules.oauth2.provider.api.Constants.REDIRECT_URI_PARAMETER;
import static org.apache.commons.lang3.StringUtils.join;
import static org.mule.runtime.http.api.HttpHeaders.Names.CONTENT_TYPE;
import static org.mule.runtime.api.metadata.MediaType.HTML;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;

import com.mulesoft.modules.oauth2.provider.api.Constants.ResponseType;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;

import java.util.Map;
import java.util.Set;

public class ServeLoginPageProcessor extends AbstractServePageProcessor {

  public ServeLoginPageProcessor(final OAuthConfiguration configuration) {
    super(configuration, configuration.getAuthorizationConfig().getLoginPage());
  }

  public void process(final RequestData requestData, Client client, Set<String> effectiveScopes,
                      HttpResponseBuilder responseBuilder)
      throws SecurityException {
    final String clientId = getMandatoryParameterOrFail(requestData, CLIENT_ID_PARAMETER);
    final ResponseType responseType = getSupportedResponseTypeOrFail(requestData);
    final String redirectUri = getMandatoryParameterOrFail(requestData, REDIRECT_URI_PARAMETER);

    if (client == null) {
      client = configuration.getClientManager().getClientById(clientId);
    }

    final Map<String, Object> context = keyValuePairsToMap("PROVIDER_NAME", configuration.getProviderName(),
                                                           "CLIENT_ID", clientId,
                                                           "CLIENT_NAME", client.getClientName(),
                                                           "RESPONSE_TYPE", responseType.toString(),
                                                           "REDIRECT_URI", redirectUri,
                                                           "SCOPE", join(effectiveScopes, ' '),
                                                           "SCOPE_SET", effectiveScopes);

    responseBuilder.entity(new ByteArrayHttpEntity(render(context).getBytes()));
    responseBuilder.addHeader(CONTENT_TYPE, HTML.toRfcString());
  }

}
