/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import static com.mulesoft.modules.oauth2.provider.api.Constants.CLIENT_ID_PARAMETER;
import static com.mulesoft.modules.oauth2.provider.api.Constants.REDIRECT_URI_PARAMETER;
import static com.mulesoft.modules.oauth2.provider.api.Constants.RESPONSE_TYPE_PARAMETER;
import static com.mulesoft.modules.oauth2.provider.api.Constants.SCOPE_PARAMETER;
import static com.mulesoft.modules.oauth2.provider.internal.processor.RequestProcessingExceptionFactory.noClientIdException;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.util.Pair;

import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;

import java.util.Set;

public class ValidateAuthorizationRequestProcessor extends OAuth2ProviderRequestProcessor {

  public ValidateAuthorizationRequestProcessor(OAuthConfiguration configuration) {
    super(configuration);
  }

  public Pair<Set<String>, Client> process(final RequestData requestData) throws SecurityException {

    failIfParameterPresentMultipleTimes(requestData, RESPONSE_TYPE_PARAMETER, CLIENT_ID_PARAMETER, REDIRECT_URI_PARAMETER,
                                        SCOPE_PARAMETER);

    // just for validation purpose, don't care of the value at this point
    getSupportedResponseTypeOrFail(requestData);

    //Check if clientId parameter is present
    try {
      getMandatoryParameterOrFail(requestData, CLIENT_ID_PARAMETER);
    } catch (RequestProcessingException e) {
      throw noClientIdException();
    }

    //Check that client id is a valid one
    final Client client = getKnownClientOrFail(requestData);

    // just for validation purpose too
    getValidRedirectionUriOrFail(client, requestData);

    final Set<String> effectiveScopes = getEffectiveScopes(requestData, client);
    return new Pair<>(effectiveScopes, client);
  }
}
