/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.security;

import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Security provider that delegate method calls
 */
public abstract class DelegateSecurityProvider implements SecurityProvider {

  private SecurityProvider delegate;
  private final static Logger LOGGER = LoggerFactory.getLogger(DelegateSecurityProvider.class);

  public DelegateSecurityProvider(SecurityProvider delegate) {
    this.delegate = delegate;
  }

  @Override
  public Authentication authenticate(Authentication authentication) throws SecurityException {
    ClassLoader c = Thread.currentThread().getContextClassLoader();
    try {
      Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
      return delegate.authenticate(authentication);
    } catch (Exception e) {
      LOGGER.warn(e.getMessage(), e);
    } finally {
      Thread.currentThread().setContextClassLoader(c);
    }
    return null;
  }

  @Override
  public boolean supports(Class<?> aClass) {
    return delegate.supports(aClass);
  }

  @Override
  public SecurityContext createSecurityContext(Authentication authentication) throws UnknownAuthenticationTypeException {
    return delegate.createSecurityContext(authentication);
  }

  @Override
  public String getName() {
    return delegate.getName();
  }

  @Override
  public void setName(String s) {
    delegate.setName(s);
  }
}
