/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.oauth2.provider.internal.security;

import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.core.api.security.SecurityProvider;

import com.mulesoft.modules.oauth2.provider.api.ResourceOwnerAuthentication;

public class ResourceOwnerSecurityProvider extends DelegateSecurityProvider {

  public ResourceOwnerSecurityProvider(SecurityProvider delegate) {
    super(delegate);
  }

  @Override
  public ResourceOwnerAuthentication authenticate(Authentication authentication) throws SecurityException {
    Authentication authenticatedAuth = super.authenticate(authentication);
    return new ResourceOwnerAuthentication.Builder()
        .withPrincipal(authenticatedAuth.getPrincipal())
        //After authentication, never save credentials
        .withCredentials(null)
        .withProperties(authenticatedAuth.getProperties())
        .build();
  }

}
