/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal.processor;

import com.mulesoft.modules.oauth2.provider.api.exception.OAuth2ConfigurationException;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.processor.OAuth2ProviderRequestProcessor;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public abstract class AbstractServePageProcessor
extends OAuth2ProviderRequestProcessor {
    private final Template template;
    private final String loginPage;

    public AbstractServePageProcessor(OAuthConfiguration configuration, String page) {
        super(configuration);
        Properties properties = new Properties();
        properties.setProperty("resource.loader", "file,class");
        properties.setProperty("file.resource.loader.class", "com.mulesoft.modules.oauth2.provider.internal.velocity.FileResourceLoader");
        properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        VelocityEngine velocity = new VelocityEngine(properties);
        this.loginPage = configuration.getAuthorizationConfig().getLoginPage();
        this.template = velocity.resourceExists(this.loginPage) ? velocity.getTemplate(page) : null;
    }

    protected String render(Map<String, Object> context) {
        if (this.template == null) {
            throw new OAuth2ConfigurationException("Authorization page not found, check your configuration: " + this.loginPage);
        }
        VelocityContext velocityContext = new VelocityContext(context);
        StringWriter mergedContent = new StringWriter();
        this.template.merge((Context)velocityContext, (Writer)mergedContent);
        return mergedContent.toString();
    }
}

