/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.internal;

import com.mulesoft.modules.oauth2.provider.api.Constants;
import com.mulesoft.modules.oauth2.provider.api.client.Client;
import com.mulesoft.modules.oauth2.provider.api.client.ClientStore;
import com.mulesoft.modules.oauth2.provider.api.client.ClientType;
import com.mulesoft.modules.oauth2.provider.api.client.ObjectStoreClientStore;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationCodeStore;
import com.mulesoft.modules.oauth2.provider.api.code.AuthorizationConfig;
import com.mulesoft.modules.oauth2.provider.api.code.ObjectStoreAuthorizationCode;
import com.mulesoft.modules.oauth2.provider.api.ratelimit.PeriodRateLimiter;
import com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter;
import com.mulesoft.modules.oauth2.provider.api.token.ObjectStoreAccessAndRefreshTokenStore;
import com.mulesoft.modules.oauth2.provider.api.token.ObjectStoreAccessTokenStore;
import com.mulesoft.modules.oauth2.provider.api.token.TokenConfig;
import com.mulesoft.modules.oauth2.provider.api.token.TokenStore;
import com.mulesoft.modules.oauth2.provider.api.token.generator.TokenGeneratorDefaultStrategy;
import com.mulesoft.modules.oauth2.provider.api.token.generator.TokenGeneratorStrategy;
import com.mulesoft.modules.oauth2.provider.internal.OAuth2ProviderOperations;
import com.mulesoft.modules.oauth2.provider.internal.Utils;
import com.mulesoft.modules.oauth2.provider.internal.client.ClientManager;
import com.mulesoft.modules.oauth2.provider.internal.code.AuthorizationCodeManager;
import com.mulesoft.modules.oauth2.provider.internal.config.IllegalConfigurationException;
import com.mulesoft.modules.oauth2.provider.internal.config.OAuthConfiguration;
import com.mulesoft.modules.oauth2.provider.internal.generator.AuthorizationHandlerGenerator;
import com.mulesoft.modules.oauth2.provider.internal.generator.CreateAccessTokenHandlerGenerator;
import com.mulesoft.modules.oauth2.provider.internal.generator.RequestHandlerGenerator;
import com.mulesoft.modules.oauth2.provider.internal.security.ResourceOwnerSecurityProvider;
import com.mulesoft.modules.oauth2.provider.internal.security.SpringAwareResourceOwnerSecurityProvider;
import com.mulesoft.modules.oauth2.provider.internal.token.TokenManager;
import com.mulesoft.modules.oauth2.provider.internal.token.TokenSecurityProvider;
import com.mulesoft.modules.oauth2.provider.internal.token.generator.AbstractRefreshTokenStrategy;
import com.mulesoft.modules.oauth2.provider.internal.token.generator.ObjectStoreAwareRefreshTokenStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetailsService;

@Configuration
@Operations(value={OAuth2ProviderOperations.class})
public class OAuth2ProviderConfiguration
implements Initialisable,
Startable,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2ProviderConfiguration.class);
    private static List<? extends RequestHandlerGenerator> REQUEST_HANDLER_GENERATORS;
    private static final int EXPIRATION_INTERVAL_PERCENTAGE = 10;
    private static final long DEFAULT_TOKEN_OS_ENTRY_TTL_MS;
    private static final long DEFAULT_AUTHORIZATION_CODE_OS_ENTRY_TTL_MS;
    private static final boolean DEFAULT_PERSISTENCE_SETTING = true;
    private static final String DEFAULT_VALUES_DELIMITER = ",";
    public static String WWW_AUTHENTICATE_HEADER_VALUE;
    @RefName
    private String name;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    private String providerName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ConfigReference(namespace="HTTP", name="LISTENER_CONFIG")
    private String listenerConfig;
    @Parameter
    @Optional
    @NullSafe(defaultImplementingType=PeriodRateLimiter.class)
    private RateLimiter clientValidationRateLimiter;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Alias(value="clientStore")
    @ObjectStoreReference
    private ObjectStore clientStoreObjectStore;
    @Parameter
    @Optional
    @Alias(value="resourceOwnerSecurityProvider")
    private String resourceOwnerSecurityProvider;
    @Parameter
    @Optional
    @Alias(value="clientSecurityProvider")
    private String clientSecurityProvider;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @ParameterDsl(allowInlineDefinition=false)
    @NullSafe(defaultImplementingType=TokenGeneratorDefaultStrategy.class)
    private TokenGeneratorStrategy tokenGeneratorStrategy;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="AUTHORIZATION_CODE")
    @Alias(value="supportedGrantTypes")
    private String supportedGrantTypesString;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Alias(value="scopes")
    private String scopesString;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Alias(value="defaultScopes")
    private String defaultScopesString;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @NullSafe
    private TokenConfig tokenConfig;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @NullSafe
    private AuthorizationConfig authorizationConfig;
    @Parameter
    @Optional
    @NullSafe
    private List<Client> clients;
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    @Inject
    @Named(value="_muleSecurityManager")
    private SecurityManager securityManager;
    @Inject
    private HttpService httpService;
    @Inject
    private Registry registry;
    private OAuthConfiguration oAuthConfiguration;
    private TokenManager tokenManager;
    private TokenStore tokenStore;
    private TokenSecurityProvider tokenSecurityProvider;
    private ClientManager clientManager;
    private ClientStore clientStore;
    private AuthorizationCodeStore authorizationCodeStore;
    private Set<Constants.ProviderGrantType> supportedGrantTypes;
    private Set<String> scopes;
    private Set<String> defaultScopes;

    public void initialise() {
        if (this.providerName == null) {
            this.providerName = this.name;
        }
        this.supportedGrantTypes = Utils.parseProviderGrantTypes(this.supportedGrantTypesString);
        if (this.resourceOwnerSecurityProvider == null && this.isResourceOwnerSecurityProvidedNeeded()) {
            throw new IllegalConfigurationException(String.format("A Resource Owner Security Provided should be configured unless %s is the only supported grant type", new Object[]{Constants.ProviderGrantType.CLIENT_CREDENTIALS}));
        }
        if (this.clientSecurityProvider == null && this.isClientSecurityProviderNeeded()) {
            throw new IllegalConfigurationException(String.format("A Client Security Provided should be configured unless only %s clients are used or %s with secrets set", new Object[]{ClientType.PUBLIC, ClientType.CONFIDENTIAL}));
        }
        this.scopes = this.scopesString != null ? Utils.tokenize(this.scopesString, DEFAULT_VALUES_DELIMITER) : new HashSet();
        Set<Object> set = this.defaultScopes = this.defaultScopesString != null ? Utils.tokenize(this.defaultScopesString, DEFAULT_VALUES_DELIMITER) : new HashSet();
        if (!this.scopes.containsAll(this.defaultScopes)) {
            throw new IllegalConfigurationException("Error configuring default scopes. Default scopes should be a subset of the configured scopes for the OAuth provider.");
        }
    }

    public void start() throws MuleException {
        HttpServer httpServer;
        REQUEST_HANDLER_GENERATORS = Arrays.asList(new AuthorizationHandlerGenerator(), new CreateAccessTokenHandlerGenerator());
        try {
            httpServer = this.httpService.getServerFactory().lookup(this.listenerConfig);
        }
        catch (ServerNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("OAuth provider '%s' defines '%s' as the http:listener-config to use for provisioning callbacks, but no such definition exists in the application configuration", this.providerName, this.listenerConfig)), (Throwable)e);
        }
        OAuthConfiguration OAuthConfiguration2 = this.createConfiguration(httpServer);
        for (RequestHandlerGenerator requestHandlerGenerator : REQUEST_HANDLER_GENERATORS) {
            requestHandlerGenerator.generate(OAuthConfiguration2);
        }
    }

    private OAuthConfiguration createConfiguration(HttpServer httpServer) throws MuleException {
        this.configureStores();
        this.clientManager = new ClientManager(this.clientStore);
        this.addClientsToStore();
        AuthorizationCodeManager authorizationCodeManager = new AuthorizationCodeManager(this.authorizationCodeStore);
        ((AbstractRefreshTokenStrategy)this.tokenConfig.getRefreshTokenStrategy()).setTokenGeneratorStrategy(this.tokenGeneratorStrategy);
        this.tokenManager = new TokenManager(this.tokenStore, this.tokenGeneratorStrategy, this.tokenConfig.getRefreshTokenStrategy(), this.tokenConfig.getTokenTtl(), this.tokenConfig.getTokenTtlTimeUnit());
        this.tokenSecurityProvider = new TokenSecurityProvider(this.name, this.tokenManager);
        this.tokenSecurityProvider.initialise();
        this.securityManager.addProvider((SecurityProvider)this.tokenSecurityProvider);
        this.oAuthConfiguration = new OAuthConfiguration(this.providerName, httpServer, this.createResourceOwnerSecurityProvider(), this.createClientSecurityProvider(), this.tokenConfig, this.authorizationConfig, this.clientManager, authorizationCodeManager, this.tokenManager, this.scopes, this.defaultScopes, this.supportedGrantTypes, this.clientValidationRateLimiter);
        return this.oAuthConfiguration;
    }

    private boolean isResourceOwnerSecurityProvidedNeeded() {
        return !this.supportedGrantTypes.contains((Object)Constants.ProviderGrantType.CLIENT_CREDENTIALS) || this.supportedGrantTypes.size() > 1;
    }

    private ResourceOwnerSecurityProvider createResourceOwnerSecurityProvider() {
        if (this.resourceOwnerSecurityProvider != null) {
            SecurityProvider foundResourceOwnerSecurityProvider = this.securityManager.getProvider(this.resourceOwnerSecurityProvider);
            if (foundResourceOwnerSecurityProvider == null) {
                throw new IllegalConfigurationException(String.format("Could not find resourceOwnerSecurityProvider referenced by the name: '%s'", this.resourceOwnerSecurityProvider));
            }
            if (ClassUtils.isClassOnPath((String)"org.springframework.security.core.userdetails.UserDetailsService", this.getClass())) {
                List userDetailsServices = this.registry.lookupAllByType(UserDetailsService.class);
                if (userDetailsServices == null) {
                    userDetailsServices = Collections.emptyList();
                }
                return new SpringAwareResourceOwnerSecurityProvider(foundResourceOwnerSecurityProvider, new ArrayList<UserDetailsService>(userDetailsServices));
            }
            return new ResourceOwnerSecurityProvider(foundResourceOwnerSecurityProvider);
        }
        return null;
    }

    private boolean isClientSecurityProviderNeeded() {
        return this.clients.stream().anyMatch(c -> c.getType().equals((Object)ClientType.CONFIDENTIAL) && StringUtils.isBlank((String)c.getSecret()));
    }

    private SecurityProvider createClientSecurityProvider() {
        if (this.clientSecurityProvider != null) {
            SecurityProvider foundClientSecurityProvider = this.securityManager.getProvider(this.clientSecurityProvider);
            if (foundClientSecurityProvider == null) {
                throw new IllegalConfigurationException(String.format("Could not find clientSecurityProvider referenced by the name: '%s'", this.clientSecurityProvider));
            }
            return foundClientSecurityProvider;
        }
        return null;
    }

    private void configureStores() throws MuleException {
        this.initializeDefaultStores();
    }

    private void initializeDefaultStores() throws MuleException {
        this.initializeClientStore();
        this.initializeAuthorizationCodeStore();
        this.initializeTokenStore();
    }

    private void addClientsToStore() {
        if (this.clients != null) {
            for (Client client : this.clients) {
                try {
                    this.clientManager.addClient(client, false);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalConfigurationException(e.getMessage());
                }
            }
        }
    }

    private void initializeClientStore() throws MuleException {
        this.clientStore = new ObjectStoreClientStore();
        if (this.useDefaultClientStore()) {
            ObjectStore clientStoreObjectStore = this.objectStoreManager.getOrCreateObjectStore("Clients", ObjectStoreSettings.builder().entryTtl(Long.valueOf(0L)).expirationInterval(Long.valueOf(0L)).persistent(true).build());
            ((ObjectStoreClientStore)this.clientStore).setObjectStore(clientStoreObjectStore);
            try {
                ((ObjectStoreClientStore)this.clientStore).getClientObjectStore().open();
            }
            catch (ObjectStoreException ose) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error initializing persistent object store for Clients"));
            }
        } else {
            ((ObjectStoreClientStore)this.clientStore).setObjectStore(this.clientStoreObjectStore);
            LifecycleUtils.startIfNeeded((Object)this.clientStoreObjectStore);
        }
    }

    private void initializeAuthorizationCodeStore() throws MuleException {
        this.authorizationCodeStore = new ObjectStoreAuthorizationCode();
        if (this.useDefaultAuthorizationCodeStore()) {
            ObjectStore authorizationCodeObjectStore = this.objectStoreManager.getOrCreateObjectStore("AuthorizationCodes", ObjectStoreSettings.builder().persistent(true).entryTtl(Long.valueOf(DEFAULT_AUTHORIZATION_CODE_OS_ENTRY_TTL_MS)).expirationInterval(Long.valueOf(DEFAULT_AUTHORIZATION_CODE_OS_ENTRY_TTL_MS * 10L / 100L)).maxEntries(Integer.valueOf(-1)).build());
            ((ObjectStoreAuthorizationCode)this.authorizationCodeStore).setObjectStore(authorizationCodeObjectStore);
        } else {
            ((ObjectStoreAuthorizationCode)this.authorizationCodeStore).setObjectStore(this.authorizationConfig.getAuthorizationCodeStore());
            LifecycleUtils.startIfNeeded((Object)this.authorizationConfig.getAuthorizationCodeStore());
        }
    }

    private void initializeTokenStore() throws MuleException {
        ObjectStoreAccessTokenStore tmpTokenStore;
        if (this.shouldStoreRefreshTokens()) {
            tmpTokenStore = new ObjectStoreAccessAndRefreshTokenStore();
            ObjectStore refreshTokensObjectStore = ((ObjectStoreAwareRefreshTokenStrategy)this.tokenConfig.getRefreshTokenStrategy()).getObjectStore();
            if (refreshTokensObjectStore != null) {
                LifecycleUtils.startIfNeeded((Object)refreshTokensObjectStore);
                tmpTokenStore.setRefreshTokenObjectStore(refreshTokensObjectStore);
            } else {
                tmpTokenStore.setRefreshTokenObjectStore(this.objectStoreManager.getOrCreateObjectStore("RefreshTokens", ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(-1)).entryTtl(Long.valueOf(DEFAULT_TOKEN_OS_ENTRY_TTL_MS)).expirationInterval(Long.valueOf(DEFAULT_TOKEN_OS_ENTRY_TTL_MS * 10L / 100L)).build()));
            }
        } else {
            tmpTokenStore = new ObjectStoreAccessTokenStore();
        }
        if (this.useDefaultAccessTokenStore()) {
            long tokenTtlMilliseconds = this.tokenConfig.getTokenTtlTimeUnit().toMillis(this.tokenConfig.getTokenTtl());
            tmpTokenStore.setAccessTokenObjectStore(this.objectStoreManager.getOrCreateObjectStore("AccessTokens", ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(-1)).entryTtl(Long.valueOf(tokenTtlMilliseconds)).expirationInterval(Long.valueOf(tokenTtlMilliseconds * 10L / 100L)).build()));
        } else {
            tmpTokenStore.setAccessTokenObjectStore(this.tokenConfig.getTokenStore());
            LifecycleUtils.startIfNeeded((Object)this.tokenConfig.getTokenStore());
        }
        this.tokenStore = tmpTokenStore;
    }

    private boolean useDefaultClientStore() {
        return this.clientStoreObjectStore == null;
    }

    private boolean useDefaultAccessTokenStore() {
        return this.tokenConfig == null || this.tokenConfig.getTokenStore() == null;
    }

    private boolean shouldStoreRefreshTokens() {
        return ObjectStoreAwareRefreshTokenStrategy.class.isAssignableFrom(this.tokenConfig.getRefreshTokenStrategy().getClass());
    }

    private boolean useDefaultAuthorizationCodeStore() {
        return this.authorizationConfig == null || this.authorizationConfig.getAuthorizationCodeStore() == null;
    }

    public OAuthConfiguration getOAuthConfiguration() {
        return this.oAuthConfiguration;
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    public AuthorizationCodeStore getAuthorizationCodeStore() {
        return this.authorizationCodeStore;
    }

    public TokenStore getTokenStore() {
        return this.tokenStore;
    }

    public TokenSecurityProvider getTokenSecurityProvider() {
        return this.tokenSecurityProvider;
    }

    public void stop() throws MuleException {
        if (Objects.nonNull(this.securityManager.getProvider(this.tokenSecurityProvider.getName()))) {
            this.securityManager.removeProvider(this.tokenSecurityProvider.getName());
        }
        for (RequestHandlerGenerator requestHandlerGenerator : REQUEST_HANDLER_GENERATORS) {
            requestHandlerGenerator.dispose();
        }
    }

    static {
        DEFAULT_TOKEN_OS_ENTRY_TTL_MS = TimeUnit.SECONDS.toMillis(86400L);
        DEFAULT_AUTHORIZATION_CODE_OS_ENTRY_TTL_MS = TimeUnit.SECONDS.toMillis(600L);
        WWW_AUTHENTICATE_HEADER_VALUE = "Bearer realm=\"OAuth2 Client Realm\"";
    }
}

