/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.oauth2.provider.api.ratelimit;

import com.mulesoft.modules.oauth2.provider.api.ratelimit.RateLimiter;
import com.mulesoft.modules.oauth2.provider.internal.ratelimit.RateLimitExceededException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class PeriodRateLimiter
implements RateLimiter {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="600")
    private int duration;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="SECONDS")
    private TimeUnit durationTimeUnit;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="5")
    private int maximumFailureCount;
    private LazyValue<Integer> autoResetAfterSeconds = new LazyValue(() -> (int)this.durationTimeUnit.toSeconds(this.duration));
    private final ConcurrentMap<String, Pair<? extends Instant, Integer>> cache = new ConcurrentHashMap<String, Pair<? extends Instant, Integer>>();

    @Override
    public void checkOperationAuthorized(RateLimiter.Operation operation, String context) throws RateLimitExceededException {
        String cacheKey = this.getCacheKey(operation, context);
        Pair autoResetInstantAndFailureCount = (Pair)this.cache.get(cacheKey);
        if (autoResetInstantAndFailureCount == null) {
            return;
        }
        if (((Instant)autoResetInstantAndFailureCount.getLeft()).isBefore(Instant.now())) {
            this.cache.remove(cacheKey);
            return;
        }
        if ((Integer)autoResetInstantAndFailureCount.getRight() < this.maximumFailureCount) {
            return;
        }
        throw new RateLimitExceededException("Maximum of " + this.maximumFailureCount + " failed attempts reached");
    }

    @Override
    public void recordOperationOutcome(RateLimiter.Operation operation, String context, RateLimiter.Outcome outcome) {
        String cacheKey = this.getCacheKey(operation, context);
        if (outcome == RateLimiter.Outcome.SUCCESS) {
            this.cache.remove(cacheKey);
            return;
        }
        Pair autoResetInstantAndFailureCount = (Pair)this.cache.get(cacheKey);
        if (autoResetInstantAndFailureCount == null) {
            this.cache.put(cacheKey, (Pair<? extends Instant, Integer>)Pair.of((Object)Instant.now().plus(Duration.ofSeconds(((Integer)this.autoResetAfterSeconds.get()).intValue())), (Object)1));
        } else {
            this.cache.put(cacheKey, (Pair<? extends Instant, Integer>)Pair.of((Object)autoResetInstantAndFailureCount.getLeft(), (Object)((Integer)autoResetInstantAndFailureCount.getRight() + 1)));
        }
    }

    private String getCacheKey(RateLimiter.Operation operation, String context) {
        return operation.toString() + "|" + context;
    }

    public int getMaximumFailureCount() {
        return this.maximumFailureCount;
    }

    public void setMaximumFailureCount(int maximumFailureCount) {
        this.maximumFailureCount = maximumFailureCount;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setDuration(int duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.durationTimeUnit = timeUnit;
        this.autoResetAfterSeconds = new LazyValue(() -> (int)this.durationTimeUnit.toSeconds(duration));
    }

    public TimeUnit getDurationTimeUnit() {
        return this.durationTimeUnit;
    }

    public void setDurationTimeUnit(TimeUnit durationTimeUnit) {
        this.durationTimeUnit = durationTimeUnit;
    }

    public LazyValue<Integer> getAutoResetAfterSeconds() {
        return this.autoResetAfterSeconds;
    }

    public void setAutoResetAfterSeconds(LazyValue<Integer> autoResetAfterSeconds) {
        this.autoResetAfterSeconds = autoResetAfterSeconds;
    }

    public ConcurrentMap<String, Pair<? extends Instant, Integer>> getCache() {
        return this.cache;
    }
}

