/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.internal.keyfactories;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public abstract class AESFactory {
    private static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final String FIPS_SECURITY_MODEL = "fips140-2";
    private static final String PROPERTY_SECURITY_MODEL = "mule.security.model";

    public static boolean isFipsEnabled() {
        return FIPS_SECURITY_MODEL.equals(System.getProperty(PROPERTY_SECURITY_MODEL));
    }

    public static Cipher getCipher(String xform) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        if (AESFactory.isFipsEnabled()) {
            return Cipher.getInstance(xform);
        }
        return Cipher.getInstance(xform, BOUNCY_CASTLE_PROVIDER);
    }

    public static boolean isJCEInstalled() {
        try {
            int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
            return maxKeyLen > 128;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    static {
        if (!AESFactory.isFipsEnabled()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

