/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.configuration.properties.api;

import com.mulesoft.modules.configuration.properties.internal.extension.SecureConfigurationPropertiesProvider;
import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncryptionAlgorithm;
import com.mulesoft.modules.configuration.properties.internal.jce.algorithms.EncryptionMode;
import java.util.List;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;

public class SecureConfigurationPropertiesProviderFactory
implements ConfigurationPropertiesProviderFactory {
    public static final String EXTENSION_NAMESPACE = "secure-properties";
    public static final String SECURE_CONFIGURATION_PROPERTIES_ELEMENT = "config";
    public static final ComponentIdentifier SECURE_CONFIGURATION_PROPERTIES = ComponentIdentifier.builder().namespace("secure-properties").name("config").build();

    public ComponentIdentifier getSupportedComponentIdentifier() {
        return SECURE_CONFIGURATION_PROPERTIES;
    }

    public SecureConfigurationPropertiesProvider createProvider(ConfigurationParameters parameters, ResourceProvider externalResourceProvider) {
        String file = parameters.getStringParameter("file");
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (String)"Required attribute 'file' of 'secure-configuration-properties' not found");
        String key = parameters.getStringParameter("key");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"Required attribute 'key' of 'secure-configuration-properties' not found");
        ComponentIdentifier encryptComponentIdentifier = ComponentIdentifier.builder().namespace(EXTENSION_NAMESPACE).name("encrypt").build();
        String algorithm = this.getAlgorithm(parameters.getComplexConfigurationParameter(encryptComponentIdentifier));
        String mode = this.getMode(parameters.getComplexConfigurationParameter(encryptComponentIdentifier));
        return new SecureConfigurationPropertiesProvider(externalResourceProvider, file, algorithm, key, mode);
    }

    private String getAlgorithm(List<ConfigurationParameters> encryptionParameters) {
        return this.getProperty(encryptionParameters, "algorithm", EncryptionAlgorithm.AES.name());
    }

    private String getMode(List<ConfigurationParameters> encryptionParameters) {
        return this.getProperty(encryptionParameters, "mode", EncryptionMode.CBC.name());
    }

    private String getProperty(List<ConfigurationParameters> encryptionParameters, String property, String defaultValue) {
        if (encryptionParameters.size() != 1) {
            return defaultValue;
        }
        String propertyValue = encryptionParameters.get(0).getStringParameter(property);
        return propertyValue != null ? propertyValue : defaultValue;
    }
}

