/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.modules.configuration.properties.api;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import static org.mule.runtime.api.meta.Category.SELECT;
import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;
import static org.mule.runtime.api.meta.model.display.PathModel.Location.EMBEDDED;
import static org.mule.runtime.api.meta.model.display.PathModel.Type.FILE;

import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionLoadingDelegate;

/**
 * Declares extension for Secure Properties Configuration module
 *
 * @since 1.0
 */
public class SecureConfigPropertiesExtensionLoadingDelegate implements ExtensionLoadingDelegate {

  public static final String EXTENSION_NAME = "Secure Properties";
  public static final String VERSION = "1.2.0";

  @Override
  public void accept(ExtensionDeclarer extensionDeclarer, ExtensionLoadingContext context) {
    ConfigurationDeclarer configurationDeclarer = extensionDeclarer.named(EXTENSION_NAME)
        .describedAs("Crafted Config Properties Extension")
        .withCategory(SELECT)
        .onVersion(VERSION)
        .fromVendor("Mulesoft")
        .withConfig("config");

    ParameterGroupDeclarer defaultParameterGroup = configurationDeclarer.onDefaultParameterGroup();
    defaultParameterGroup
        .withRequiredParameter("file").ofType(BaseTypeBuilder.create(JAVA).stringType().build())
        .withExpressionSupport(NOT_SUPPORTED)
        .withDisplayModel(DisplayModel.builder().path(new PathModel(FILE, false, EMBEDDED, new String[] {"yaml", "properties"}))
            .build())
        .describedAs(" The location of the file with the secure configuration properties to use. "
            + "It may be a location in the classpath or an absolute location. \nThe file location"
            + " value may also contains references to properties that will only be resolved based on "
            + "system properties or properties set at deployment time.");


    defaultParameterGroup
        .withRequiredParameter("key").ofType(BaseTypeBuilder.create(JAVA).stringType().build());
    defaultParameterGroup.withOptionalParameter("fileLevelEncryption").ofType(BaseTypeBuilder.create(JAVA).booleanType().build())
        .defaultingTo(Boolean.FALSE);
    defaultParameterGroup.withOptionalParameter("encoding").ofType(BaseTypeBuilder.create(JAVA).booleanType().build());

    ParameterGroupDeclarer parameterGroupDeclarer =
        configurationDeclarer.onParameterGroup("encrypt").withDslInlineRepresentation(true);

    ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    parameterGroupDeclarer.withOptionalParameter("algorithm").ofType(typeLoader.load(EncryptionAlgorithm.class))
        .defaultingTo(EncryptionAlgorithm.AES);
    parameterGroupDeclarer.withOptionalParameter("mode").ofType(typeLoader.load(EncryptionMode.class))
        .defaultingTo(EncryptionMode.CBC);
  }

}
