/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.incoming;

import com.mulesoft.modules.wss.api.CredentialsConfig;
import com.mulesoft.modules.wss.api.handler.CredentialsCallbackHandler;
import com.mulesoft.modules.wss.api.incoming.IncomingWss;
import com.mulesoft.modules.wss.api.store.KeyStoreConfiguration;
import com.mulesoft.modules.wss.internal.error.MissingCertificateException;
import com.mulesoft.modules.wss.internal.error.WssException;
import java.io.IOException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.EncryptedKeyProcessor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public class DecryptionConfig
implements IncomingWss {
    @Parameter
    @DisplayName(value="KeyStore Configuration")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="keystore-config")
    private KeyStoreConfiguration keyStore;

    @Override
    public void setUp(WSSConfig wssConfig, RequestData data) throws WssException {
        try {
            CredentialsCallbackHandler cch = (CredentialsCallbackHandler)data.getCallbackHandler();
            cch.setDecryptionConfigCredentials(new CredentialsConfig(this.keyStore.getAlias(), this.keyStore.getKeyPassword()));
            data.setDecCrypto((Crypto)new Merlin(this.keyStore.getWssProperties(), this.getClass().getClassLoader(), null));
            wssConfig.setProcessor(WSConstants.ENCRYPTED_KEY, EncryptedKeyProcessor.class);
        }
        catch (WSSecurityException e) {
            throw new WssException("Error setting decrypt configuration: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MissingCertificateException("Unable to get certificate from Key Store.", e);
        }
    }
}

