/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.incoming;

import com.mulesoft.modules.wss.api.incoming.AuthenticateUserConfig;
import com.mulesoft.modules.wss.internal.incoming.LDAPValidator;
import java.util.HashMap;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.validate.Validator;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;

public class LDAPConfig
implements AuthenticateUserConfig {
    @Parameter
    private String providerUrl;
    @Parameter
    private String userDn;
    @Parameter
    private String password;
    @Parameter
    private String searchBase;
    @Parameter
    private String searchFilter;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Parameter
    private boolean searchInSubtree;

    @Override
    public Validator getValidator() {
        HashMap<String, String> environmentProperties = new HashMap<String, String>();
        environmentProperties.put("java.naming.ldap.version", "3");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool", "true");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.maxsize", "10");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.prefsize", "5");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.initsize", "3");
        environmentProperties.put("com.sun.jndi.ldap.connect.timeout", "10000");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.timeout", "60000");
        environmentProperties.put("com.sun.jndi.ldap.connect.pool.protocol", "plain");
        DefaultSpringSecurityContextSource defaultSpringSecurityContextSource = new DefaultSpringSecurityContextSource(this.providerUrl);
        defaultSpringSecurityContextSource.setUserDn(this.userDn);
        defaultSpringSecurityContextSource.setPassword(this.password);
        defaultSpringSecurityContextSource.setBaseEnvironmentProperties(environmentProperties);
        defaultSpringSecurityContextSource.afterPropertiesSet();
        FilterBasedLdapUserSearch filterBasedLdapUserSearch = new FilterBasedLdapUserSearch(this.searchBase, this.searchFilter, (BaseLdapPathContextSource)defaultSpringSecurityContextSource);
        filterBasedLdapUserSearch.setSearchSubtree(this.searchInSubtree);
        BindAuthenticator bindAuthenticator = new BindAuthenticator((BaseLdapPathContextSource)defaultSpringSecurityContextSource);
        bindAuthenticator.setUserSearch((LdapUserSearch)filterBasedLdapUserSearch);
        return new LDAPValidator(new LdapAuthenticationProvider((LdapAuthenticator)bindAuthenticator));
    }

    @Override
    public void setUp(WSSConfig wssConfig, RequestData data) {
    }
}

