/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.incoming;

import com.mulesoft.modules.wss.api.constants.SamlConfirmationMethod;
import com.mulesoft.modules.wss.api.constants.SamlVersion;
import com.mulesoft.modules.wss.api.incoming.IncomingWss;
import com.mulesoft.modules.wss.internal.error.WssException;
import com.mulesoft.modules.wss.internal.incoming.SamlAssertionValidator;
import java.util.concurrent.TimeUnit;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.SAMLTokenProcessor;
import org.apache.wss4j.dom.validate.Validator;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class VerifySamlConfig
implements IncomingWss {
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="SAML10")
    private SamlVersion samlVersion = SamlVersion.SAML10;
    @Parameter
    @Summary(value="The time in seconds within which a SAML Assertion is valid, if it does not contain a NotOnOrAfter Condition. The default is 30 minutes.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="1800")
    private Integer timeToLive = 1800;
    @Parameter
    @Summary(value="The time difference between server and client. The default is 60 seconds.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="60")
    private Integer skewTime = 60;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Summary(value="Time unit to be used in the timeToLive and skewTime configuration")
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean requireStandardSubjectConfirmationMethod;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean requireBearerSignature;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean validateSignatureAgainstProfile;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SamlConfirmationMethod requiredSubjectConfirmationMethod;

    @Override
    public void setUp(WSSConfig wssConfig, RequestData data) throws WssException {
        SamlAssertionValidator samlAssertionValidator = new SamlAssertionValidator();
        samlAssertionValidator.setTtl((int)this.timeUnit.convert(this.timeToLive.intValue(), TimeUnit.SECONDS));
        samlAssertionValidator.setFutureTTL((int)this.timeUnit.convert(this.skewTime.intValue(), TimeUnit.SECONDS));
        samlAssertionValidator.setValidateSignatureAgainstProfile(this.validateSignatureAgainstProfile);
        samlAssertionValidator.setRequireStandardSubjectConfirmationMethod(this.requireStandardSubjectConfirmationMethod);
        samlAssertionValidator.setRequireBearerSignature(this.requireBearerSignature);
        if (this.requiredSubjectConfirmationMethod != null) {
            samlAssertionValidator.setRequiredSubjectConfirmationMethod(this.requiredSubjectConfirmationMethod.getMethodStringForSAML(this.samlVersion));
        }
        if (data.getSigVerCrypto() != null) {
            samlAssertionValidator.setValidateTrustChain(true);
            data.setValidateSamlSubjectConfirmation(true);
        }
        wssConfig.setProcessor(WSConstants.SAML_TOKEN, SAMLTokenProcessor.class);
        wssConfig.setValidator(WSConstants.SAML_TOKEN, (Validator)samlAssertionValidator);
        wssConfig.setProcessor(WSConstants.SAML2_TOKEN, SAMLTokenProcessor.class);
        wssConfig.setValidator(WSConstants.SAML2_TOKEN, (Validator)samlAssertionValidator);
    }
}

