/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.modules.wss.api.incoming;

import com.mulesoft.modules.wss.api.incoming.CertificateConstraintConfig;
import com.mulesoft.modules.wss.api.incoming.IncomingWss;
import com.mulesoft.modules.wss.api.store.TrustStoreConfiguration;
import com.mulesoft.modules.wss.internal.error.MissingCertificateException;
import com.mulesoft.modules.wss.internal.error.WssException;
import java.io.IOException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.SignatureProcessor;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public class VerifySignatureConfig
implements IncomingWss {
    @Parameter
    @DisplayName(value="TrustStore Configuration")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Alias(value="truststore-config")
    private TrustStoreConfiguration trustStore;
    @ParameterGroup(name="Certificate Constraints")
    @ParameterDsl(allowReferences=false)
    private CertificateConstraintConfig certificateConstraintConfig;

    @Override
    public void setUp(WSSConfig wssConfig, RequestData data) throws WssException {
        try {
            data.setSigVerCrypto((Crypto)new Merlin(this.trustStore.getWssProperties(), this.getClass().getClassLoader(), null));
            wssConfig.setProcessor(WSConstants.SIGNATURE, SignatureProcessor.class);
            this.certificateConstraintConfig.setUp(wssConfig, data);
        }
        catch (WSSecurityException e) {
            throw new WssException("Error setting signature validation configuration: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MissingCertificateException("Unable to get certificate from TrustStore.", e);
        }
    }
}

